#ifndef __JV_DATA_STRUCT
#define __JV_DATA_STRUCT


//========================================================================
//  JRA-VAN Data Lab. JV-Data\
//
//
//   쐬: JRA-VAN \tgEFAH[
//
//========================================================================
//   (C) Copyright JRA SYSTEM SERVICE CO.,LTD. 2007 All rights reserved
//========================================================================


//////////////////// ʍ\ ////////////////////


//<N>
typedef struct
{
		char		Year[4];                   //N
		char		Month[2];                  //
		char		Day[2];                    //
}				_YMD;


//<b>
typedef struct
{
		char		Hour[2];                   //
		char		Minute[2];                 //
		char		Second[2];                 //b
}				_HMS;


 //<>
typedef struct
{
		char		Hour[2];                   //
		char		Minute[2];                 //
}				_HM;


//<>
typedef struct
{
		char		Month[2];                  //
		char		Day[2];                    //
		char		Hour[2];                   //
		char		Minute[2];                 //
}				_MDHM;


//<R[hwb_>
typedef struct
{
		char		RecordSpec[2];             //R[h
		char		DataKubun[1];              //f[^敪
		_YMD		MakeDate;                  //f[^쐬N
}				_RECORD_ID;


//<ʏP>
typedef struct
{
		char		Year[4];                   //JÔN
		char		MonthDay[4];               //JÌ
		char		JyoCD[2];                  //nR[h
		char		Kaiji[2];                  //JÉ[N]
		char		Nichiji[2];                //JÓ[N]
		char		RaceNum[2];                //[Xԍ
}				_RACE_ID;


//<ʏQ>
typedef struct
{
		char		Year[4];                   //JÔN
		char		MonthDay[4];               //JÌ
		char		JyoCD[2];                  //nR[h
		char		Kaiji[2];                  //JÉ[N]
		char		Nichiji[2];                //JÓ[N]
}				_RACE_ID2;


//<񐔁iTCY3bytej>
typedef struct
{
		char		Chakukaisu[6][3];
}				_CHAKUKAISU3_INFO;

//<񐔁iTCY4bytej>
typedef struct
{
		char		Chakukaisu[6][4];
}				_CHAKUKAISU4_INFO;

//<񐔁iTCY5bytej>
typedef struct
{
		char		Chakukaisu[6][5];
}				_CHAKUKAISU5_INFO;

//<񐔁iTCY6bytej>
typedef struct
{
		char		Chakukaisu[6][6];
}				_CHAKUKAISU6_INFO;


//<{NE݌vя>
typedef struct
{
		char		SetYear[4];                //ݒN
		char		HonSyokinTotal[10];        //{܋v
		char		FukaSyokin[10];            //t܋v
		char		ChakuKaisu[6][6];          //
}				_SEI_RUIKEI_INFO;


//<ŋߏd܏>
typedef struct
{
		_RACE_ID	SaikinJyusyoid;             //<NR>
		char		Hondai[60];                 //{
		char		Ryakusyo10[20];             //10
		char		Ryakusyo6[12];              //6
		char		Ryakusyo3[6];               //3
		char		GradeCD[1];                 //O[hR[h
		char		SyussoTosu[2];              //o
		char		KettoNum[10];               //o^ԍ
		char		Bamei[36];                  //n
}				_SAIKIN_JYUSYO_INFO;



//<{NEONE݌vя>
typedef struct
{
		char		SetYear[4];                 //ݒN
		char		HonSyokinHeichi[10];        //n{܋v
		char		HonSyokinSyogai[10];        //Q{܋v
		char		FukaSyokinHeichi[10];       //nt܋v
		char		FukaSyokinSyogai[10];       //Qt܋v
		_CHAKUKAISU6_INFO		ChakuKaisuHeichi;     //n
		_CHAKUKAISU6_INFO		ChakuKaisuSyogai;     //Q
		_CHAKUKAISU6_INFO		ChakuKaisuJyo[20];    //nʒ
		_CHAKUKAISU6_INFO		ChakuKaisuKyori[6];   //ʒ
}				_HON_ZEN_RUIKEISEI_INFO;


//<[X>
typedef struct
{
		char		YoubiCD[1];                //jR[h
		char		TokuNum[4];                //ʋԍ
		char		Hondai[60];                //{
		char		Fukudai[60];               //
		char		Kakko[60];                 //JbR
		char		HondaiEng[120];            //{艢
		char		FukudaiEng[120];           //艢
		char		KakkoEng[120];             //JbR
		char		Ryakusyo10[20];            //̂PO
		char		Ryakusyo6[12];             //̂U
		char		Ryakusyo3[6];              //̂R
		char		Kubun[1];                  //敪
		char		Nkai[3];                   //d܉[N]
}				_RACE_INFO;

//<VEn>
typedef struct
{
		char		TenkoCD[1];                //VR[h
		char		SibaBabaCD[1];             //ŔnԃR[h
		char		DirtBabaCD[1];             //_[gnԃR[h
}				_TENKO_BABA_INFO;


//<R[h>
typedef struct
{
		char		SyubetuCD[2];              //ʃR[h
		char		KigoCD[3];                 //LR[h
		char		JyuryoCD[1];               //dʎʃR[h
		char		JyokenCD[5][3];            //R[h
}				_RACE_JYOKEN;


//<RύX>
typedef struct
{
		char		Futan[3];                 //Sd
		char		KisyuCode[5];             //RR[h
		char		KisyuName[34];            //R薼
		char		MinaraiCD[1];             //R茩KR[h
}				_JC_INFO;


//<ύX>
typedef struct
{
		char		Ji[2];                 	 //
		char		Fun[2];             	 //
}				_TC_INFO;


//<R[XύX>
typedef struct
{
		char		Kyori[4];                //
		char		TruckCD[2];              //gbNR[h
}				_CC_INFO;


//////////////////// f[^\ ////////////////////


//**** PDʓo^n ****************************************
typedef struct{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_RACE_INFO	RaceInfo;                 //<[X>
		char		GradeCD[1];               //O[hR[h
		_RACE_JYOKEN	JyokenInfo;               //<R[h>
		char		Kyori[4];                 //
		char		TrackCD[2];               //gbNR[h
		char		CourseKubunCD[2];         //R[X敪
		_YMD		HandiDate;                //nf\
		char		TorokuTosu[3];            //o^

		struct _TOKUUMA_INFO                      //<o^n>
                {
				char		Num[3];                    //A
				char		KettoNum[10];              //o^ԍ
				char		Bamei[36];                 //n
				char		UmaKigoCD[2];              //nLR[h
				char		SexCD[1];                  //ʃR[h
				char		TozaiCD[1];                //tR[h
				char		ChokyosiCode[5];           //tR[h
				char		ChokyosiRyakusyo[8];       //t
				char		Futan[3];                  //Sd
				char		Koryu[1];                  //𗬋敪
		}				TokuUmaInfo[300];

		char		crlf[2];                  //R[h
}				JV_TK_TOKUUMA;


//****** QD[Xڍ ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_RACE_INFO	RaceInfo;                 //<[X>
		char		GradeCD[1];               //O[hR[h
		char		GradeCDBefore[1];         //ύXOO[hR[h
		_RACE_JYOKEN	JyokenInfo;               //<R[h>
		char		JyokenName[60];           //
		char		Kyori[4];                 //
		char		KyoriBefore[4];           //ύXO
		char		TrackCD[2];               //gbNR[h
		char		TrackCDBefore[2];         //ύXOgbNR[h
		char		CourseKubunCD[2];         //R[X敪
		char		CourseKubunCDBefore[2];   //ύXOR[X敪
		char		Honsyokin[7][8];          //{܋
		char		HonsyokinBefore[5][8];    //ύXO{܋
		char		Fukasyokin[5][8];         //t܋
		char		FukasyokinBefore[3][8];   //ύXOt܋
		char		HassoTime[4];             //
		char		HassoTimeBefore[4];       //ύXO
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		NyusenTosu[2];            //
		_TENKO_BABA_INFO        TenkoBaba;        //VEnԃR[h
		char		LapTime[25][3];           //bv^C
		char		SyogaiMileTime[4];        //Q}C^C
		char		HaronTimeS3[3];           //ORn^C
		char		HaronTimeS4[3];           //OSn^C
		char		HaronTimeL3[3];           //Rn^C
		char		HaronTimeL4[3];           //Sn^C

		struct _CORNER_INFO                       //<R[i[ʉߏ>
                {
				char		Corner[1];                //R[i[
				char		Syukaisu[1];              //
				char		Jyuni[70];                 //eʉߏ
		}				CornerInfo[4];

		char		RecordUpKubun[1];         //R[hXV敪
		char		crlf[2];                  //R[h؂
}				JV_RA_RACE;


//****** RDn[X ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		char		Wakuban[1];               //g
		char		Umaban[2];                //n
		char		KettoNum[10];             //o^ԍ
		char		Bamei[36];                //n
		char		UmaKigoCD[2];             //nLR[h
		char		SexCD[1];                 //ʃR[h
		char		HinsyuCD[1];              //iR[h
		char		KeiroCD[2];               //ѐFR[h
		char		Barei[2];                 //n
		char		TozaiCD[1];               //R[h
		char		ChokyosiCode[5];          //tR[h
		char		ChokyosiRyakusyo[8];      //t
		char		BanusiCode[6];            //nR[h
		char		BanusiName[64];           //n喼
		char		Fukusyoku[60];            //FW
		char		reserved1[60];            //\
		char		Futan[3];                 //Sd
		char		FutanBefore[3];           //ύXOSd
		char		Blinker[1];               //uJ[gp敪
		char		reserved2[1];             //\
		char		KisyuCode[5];             //RR[h
		char		KisyuCodeBefore[5];       //ύXORR[h
		char		KisyuRyakusyo[8];         //R薼
		char		KisyuRyakusyoBefore[8];   //ύXOR薼
		char		MinaraiCD[1];             //R茩KR[h
		char		MinaraiCDBefore[1];       //ύXOR茩KR[h
		char		BaTaijyu[3];              //n̏d
		char		ZogenFugo[1];             //
		char		ZogenSa[3];               //
		char		IJyoCD[1];                //ُ敪R[h
		char		NyusenJyuni[2];           //
		char		KakuteiJyuni[2];          //m蒅
		char		DochakuKubun[1];          //敪
		char		DochakuTosu[1];           //
		char		Time[4];                  //j^C
		char		ChakusaCD[3];             //R[h
		char		ChakusaCDP[3];            //+R[h
		char		ChakusaCDPP[3];           //++R[h
		char		Jyuni1c[2];               //1R[i[ł̏
		char		Jyuni2c[2];               //2R[i[ł̏
		char		Jyuni3c[2];               //3R[i[ł̏
		char		Jyuni4c[2];               //4R[i[ł̏
		char		Odds[4];                  //PIbY
		char		Ninki[2];                 //PlC
		char		Honsyokin[8];             //l{܋
		char		Fukasyokin[8];            //lt܋
		char		reserved3[3];             //\
		char		reserved4[3];             //\
		char		HaronTimeL4[3];           //Sn^C
		char		HaronTimeL3[3];           //Rn^C

		struct _CHAKUUMA_INFO                     //<1n[n]>
                {
				char		KettoNum[10];     //o^ԍ
				char		Bamei[36];        //n
		}			ChakuUmaInfo[3];

		char		TimeDiff[4];              //^C
		char		RecordUpKubun[1];         //R[hXV敪
		char		DMKubun[1];               //}CjO敪
		char		DMTime[5];                //}CjO\zj^C
		char		DMGosaP[4];               //\덷[Mx]{
		char		DMGosaM[4];               //\덷[Mx]|
		char		DMJyuni[2];               //}CjO\z
		char		KyakusituKubun[1];        //񃌁[Xr
		char		crlf[2];                  //R[h؂
}				JV_SE_RACE_UMA;


//****** SD ****************************************
//<ߏP PEEg>
typedef struct
{
		char		Umaban[2];                //n
		char		Pay[9];                   //ߋ
		char		Ninki[2];                 //lC 
}			_PAY_INFO1;


//<ߏQ nAEChE\EnP>
typedef struct
{
		char		Kumi[4];                  //g
		char		Pay[9];                   //ߋ
		char		Ninki[3];                 //lC 
}			_PAY_INFO2;


//<ߏR RA>
typedef struct{ 
		char		Kumi[6];                  //g
		char		Pay[9];                   //ߋ
		char		Ninki[3];                 //lC 
}			_PAY_INFO3;


//<ߏS RAP>
typedef struct
{
		char		Kumi[6];                  //g
		char		Pay[9];                   //ߋ
		char		Ninki[4];                 //lC
}			_PAY_INFO4;


typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		FuseirituFlag[9][1];      //stO
		char		TokubaraiFlag[9][1];      //tO
		char		HenkanFlag[9][1];         //Ԋ҃tO
		char		HenkanUma[28][1];         //ԊҔnԏ[n01`28]
		char		HenkanWaku[8][1];         //ԊҘgԏ[g1`8]
		char		HenkanDoWaku[8][1];       //Ԋғg[g1`8]
		_PAY_INFO1		PayTansyo[3];         //<P>
		_PAY_INFO1		PayFukusyo[5];        //<>
		_PAY_INFO1		PayWakuren[3];        //<gA>
		_PAY_INFO2		PayUmaren[3];         //<nA>
		_PAY_INFO2		PayWide[7];           //<Ch>
		_PAY_INFO2		PayReserved1[3];      //<\>
		_PAY_INFO2		PayUmatan[6];         //<nP>
		_PAY_INFO3		PaySanrenpuku[3];     //<3A>
		_PAY_INFO4		PaySanrentan[6];      //<3AP>
		char		crlf[2];                  //R[h؂
}				JV_HR_PAY;


//****** TD[iS|j****************************************
//<[P PEEg>
typedef struct
{
		char		Umaban[2];                //n
		char		Hyo[11];                  //[
		char		Ninki[2];                 //lC
}				_HYO_INFO1;


//<[Q nAEChEnP>
typedef struct
{
		char		Kumi[4];                  //g     
		char		Hyo[11];                  //[
		char		Ninki[3];                 //lC
}				_HYO_INFO2;


//<[R RA[>
typedef struct
{
		char		Kumi[6];                  //g     
		char		Hyo[11];                  //[
		char		Ninki[3];                 //lC
}				_HYO_INFO3;


//<[S RAP[>
typedef struct
{
		char		Kumi[6];                  //g     
		char		Hyo[11];                  //[
		char		Ninki[4];                 //lC
}				_HYO_INFO4;


typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		HatubaiFlag[7][1];        //tO@
		char		FukuChakuBaraiKey[1];     //L[
		char		HenkanUma[28][1];         //ԊҔnԏ[n01`28]
		char		HenkanWaku[8][1];         //ԊҘgԏ[g1`8]
		char		HenkanDoWaku[8][1];       //Ԋғg[g1`8]
		_HYO_INFO1	HyoTansyo[28];            //<P[>
		_HYO_INFO1	HyoFukusyo[28];           //<[>
		_HYO_INFO1	HyoWakuren[36];           //<gA[>
		_HYO_INFO2	HyoUmaren[153];           //<nA[>
		_HYO_INFO2	HyoWide[153];             //<Ch[>
		_HYO_INFO2	HyoUmatan[306];           //<nP[>
		_HYO_INFO3	HyoSanrenpuku[816];       //<3A[>
		char		HyoTotal[14][11];         //[v
		char		crlf[2];                  //R[h؂
}				JV_H1_HYOSU_ZENKAKE;

typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		HatubaiFlag[1];        	  //tO
		char		HenkanUma[18][1];         //ԊҔnԏ[n01`18]
		_HYO_INFO4	HyoSanrentan[4896];       //<3AP[>
		char		HyoTotal[2][11];         //[v
		char		crlf[2];                  //R[h؂
}				JV_H6_HYOSU_SANRENTAN;

//****** UDIbYiPgj****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		TansyoFlag[1];            //tO@P
		char		FukusyoFlag[1];           //tO@
		char		WakurenFlag[1];           //tO@gA
		char		FukuChakuBaraiKey[1];     //L[

		struct _ODDS_TANSYO_INFO                  //<PIbY>
                {
				char		Umaban[2];                //n
				char		Odds[4];                  //IbY
				char		Ninki[2];                 //lC
		}			OddsTansyoInfo[28];

		struct _ODDS_FUKUSYO_INFO                 //<IbY>
                {
				char		Umaban[2];                //n
				char		OddsLow[4];               //ŒIbY
				char		OddsHigh[4];              //ōIbY
				char		Ninki[2];                 //lC
		}			OddsFukusyoInfo[28];

		struct _ODDS_WAKUREN_INFO                 //<gAIbY>
                {
				char		Kumi[2];                  //g
				char		Odds[5];                  //IbY
				char		Ninki[2];                 //lC
		}			OddsWakurenInfo[36];

		char		TotalHyosuTansyo[11];     //P[v
		char		TotalHyosuFukusyo[11];    //[v
		char		TotalHyosuWakuren[11];    //gA[v
		char		crlf[2];                  //R[h؂
}				JV_O1_ODDS_TANFUKUWAKU;


//****** VDIbYinAj****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		UmarenFlag[1];            //tO@nA

		struct _ODDS_UMAREN_INFO                  //<nAIbY>
                {
			char		Kumi[4];                  //g
			char		Odds[6];                  //IbY
			char		Ninki[3];                 //lC
		}			OddsUmarenInfo[153];

		char		TotalHyosuUmaren[11];     //nA[v
		char		crlf[2];                  //R[h؂
}				JV_O2_ODDS_UMAREN;

//****** WDIbYiChj****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		WideFlag[1];              //tO Ch

		struct _ODDS_WIDE_INFO                    //<ChIbY>
                {
				char		Kumi[4];                  //g
				char		OddsLow[5];               //ŒIbY
				char		OddsHigh[5];              //ōIbY
				char		Ninki[3];                 //lC
		}			OddsWideInfo[153];

		char		TotalHyosuWide[11];       //Ch[v
		char		crlf[2];                  //R[h؂
}				JV_O3_ODDS_WIDE;


//****** XDIbYinPj ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		UmatanFlag[1];            //tO@nP

		struct _ODDS_UMATAN_INFO                  //<nPIbY>
                {
				char		Kumi[4];                  //g
				char		Odds[6];                  //IbY
				char		Ninki[3];                 //lC
		}			OddsUmatanInfo[306];

		char		TotalHyosuUmatan[11];     //nP[v
		char		crlf[2];                  //R[h؂
}				JV_O4_ODDS_UMATAN;


//****** PODIbYiRAj****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		SanrenpukuFlag[1];        //tO@3A

		struct _ODDS_SANREN_INFO                  //<3AIbY>
                {
				char		Kumi[6];              //g
				char		Odds[6];              //IbY
				char		Ninki[3];             //lC
		}			OddsSanrenInfo[816];

		char		TotalHyosuSanrenpuku[11]; //3A[v
		char		crlf[2];                  //R[h؂
}				JV_O5_ODDS_SANREN;


//****** PO|PDIbYiRAPj****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		char		TorokuTosu[2];            //o^
		char		SyussoTosu[2];            //o
		char		SanrentanFlag[1];         //tO@3AP

		struct _ODDS_SANRENTAN_INFO           //<3APIbY>
                {
				char		Kumi[6];              //g
				char		Odds[7];              //IbY
				char		Ninki[4];             //lC
		}			OddsSanrentanInfo[4896];

		char		TotalHyosuSanrentan[11];  //3AP[v
		char		crlf[2];                  //R[h؂
}				JV_O6_ODDS_SANRENTAN;


//****** PPDn}X^ ****************************************
typedef struct
{
		_RECORD_ID	head;            //<R[hwb_[>
		char		KettoNum[10];             //o^ԍ
		char		DelKubun[1];              //n敪
		_YMD		RegDate;                  //no^N
		_YMD		DelDate;                  //nN
		_YMD		BirthDate;                //N
		char		Bamei[36];                //n
		char		BameiKana[36];            //npJi
		char		BameiEng[60];             //n
		char		ZaikyuFlag[1];            //JRA{ݍ݂イtO
		char		Reserved[19];             //\
		char		UmaKigoCD[2];             //nLR[h
		char		SexCD[1];                 //ʃR[h
		char		HinsyuCD[1];              //iR[h
		char		KeiroCD[2];               //ѐFR[h

		struct _KETTO3_INFO                       //<R㌌>
                {
				char		HansyokuNum[10];           //ɐBo^ԍ
				char		Bamei[36];                //n
		}			Ketto3Info[14];

		char		TozaiCD[1];               //R[h
		char		ChokyosiCode[5];          //tR[h
		char		ChokyosiRyakusyo[8];      //t
		char		Syotai[20];               //Ғn於
		char		BreederCode[8];           //Y҃R[h
		char		BreederName[72];          //YҖ
		char		SanchiName[20];           //Yn
		char		BanusiCode[6];            //nR[h
		char		BanusiName[64];           //n喼
		char		RuikeiHonsyoHeiti[9];     //n{܋݌v
		char		RuikeiHonsyoSyogai[9];    //Q{܋݌v
		char		RuikeiFukaHeichi[9];      //nt܋݌v
		char		RuikeiFukaSyogai[9];      //Qt܋݌v
		char		RuikeiSyutokuHeichi[9];   //n܋݌v
		char		RuikeiSyutokuSyogai[9];   //Q܋݌v
		_CHAKUKAISU3_INFO		ChakuSogo;               //
		_CHAKUKAISU3_INFO		ChakuChuo;               //v
		_CHAKUKAISU3_INFO		ChakuKaisuBa[7];         //nʒ
		_CHAKUKAISU3_INFO		ChakuKaisuJyotai[12];    //nԕʒ
		_CHAKUKAISU3_INFO		ChakuKaisuKyori[6];      //ʒ
		char		Kyakusitu[4][3];          //rX
		char		RaceCount[3];             //o^[X
		char		crlf[2];                  //R[h؂
}				JV_UM_UMA;


//****** PQDR}X^ ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		KisyuCode[5];             //RR[h
		char		DelKubun[1];              //R薕敪
		_YMD		IssueDate;                //RƋtN
		_YMD		DelDate;                  //RƋN
		_YMD		BirthDate;                //N
		char		KisyuName[34];            //R薼
		char		reserved[34];             //\
		char		KisyuNameKana[30];        //R薼pJi
		char		KisyuRyakusyo[8];         //R薼
		char		KisyuNameEng[80];         //R薼
		char		SexCD[1];                 //ʋ敪
		char		SikakuCD[1];              //R掑iR[h
		char		MinaraiCD[1];             //R茩KR[h
		char		TozaiCD[1];               //R蓌R[h
		char		Syotai[20];               //Ғn於
		char		ChokyosiCode[5];          //tR[h
		char		ChokyosiRyakusyo[8];      //t

		struct _HATUKIJYO_INFO                    //<R>
                {
				_RACE_ID		Hatukijyoid;      //NR
				char		SyussoTosu[2];            //o
				char		KettoNum[10];             //o^ԍ
				char		Bamei[36];                //n
				char		KakuteiJyuni[2];          //m蒅
				char		IJyoCD[1];                //ُ敪R[h
		}			HatuKiJyo[2];
		

		struct _HATUSYORI_INFO                    //<>
                {
				_RACE_ID	Hatusyoriid;              //NR
				char		SyussoTosu[2];            //o
				char		KettoNum[10];             //o^ԍ
				char		Bamei[36];                //n
		}				HatuSyori[2];

		_SAIKIN_JYUSYO_INFO     SaikinJyusyo[3];      //<ŋߏd܏>
		_HON_ZEN_RUIKEISEI_INFO	HonZenRuikei[3];      //<{NEONE݌vя>
		char		crlf[2];           //R[h؂
}				JV_KS_KISYU;


//****** PRDt}X^ ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		ChokyosiCode[5];          //tR[h
		char		DelKubun[1];              //t敪
		_YMD		IssueDate;                //tƋtN
		_YMD		DelDate;                  //tƋN
		_YMD		BirthDate;                //N
		char		ChokyosiName[34];         //t
		char		ChokyosiNameKana[30];     //tpJi
		char		ChokyosiRyakusyo[8];      //t
		char		ChokyosiNameEng[80];      //t
		char		SexCD[1];                 //ʋ敪
		char		TozaiCD[1];               //tR[h
		char		Syotai[20];               //Ғn於
		_SAIKIN_JYUSYO_INFO     SaikinJyusyo[3];  //<ŋߏd܏>
		_HON_ZEN_RUIKEISEI_INFO HonZenRuikei[3];  //<{NEONE݌vя>
		char		crlf[2];                  //R[h؂
}				JV_CH_CHOKYOSI;


//******PSDY҃}X^ ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		BreederCode[8];           //Y҃R[h
		char		BreederName_Co[72];       //YҖ(@liL)
		char		BreederName[72];          //YҖ(@li)
		char		BreederNameKana[72];      //YҖpJi
		char		BreederNameEng[168];      //YҖ
		char		Address[20];              //YҏZȖ
		_SEI_RUIKEI_INFO        HonRuikei[2];     //<{NE݌vя>
		char		crlf[2];                  //R[h؂
}				JV_BR_BREEDER;


//****** PTDn}X^ ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		BanusiCode[6];            //nR[h
		char		BanusiName_Co[64];           //n喼(@liL)
		char		BanusiName[64];           //n喼(@li)
		char		BanusiNameKana[50];       //n喼pJi
		char		BanusiNameEng[100];       //n喼
		char		Fukusyoku[60];            //FW
		_SEI_RUIKEI_INFO        HonRuikei[2];     //<{NE݌vя>
		char		crlf[2];                  //R[h؂
}				JV_BN_BANUSI;


//****** PUDɐBn}X^ ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		HansyokuNum[10];           //ɐBo^ԍ
		char		reserved[8];              //\
		char		KettoNum[10];             //o^ԍ
		char		DelKubun[1];              //ɐBn敪(݂͗\ƂĎgp)
		char		Bamei[36];                //n
		char		BameiKana[40];            //npJi
		char		BameiEng[80];             //n
		char		BirthYear[4];             //N
		char		SexCD[1];                 //ʃR[h
		char		HinsyuCD[1];              //iR[h
		char		KeiroCD[2];               //ѐFR[h
		char		HansyokuMochiKubun[1];    //ɐBn敪
		char		ImportYear[4];            //AN
		char		SanchiName[20];           //Yn
		char		HansyokuFNum[10];          //nɐBo^ԍ
		char		HansyokuMNum[10];          //nɐBo^ԍ
		char		crlf[2];                  //R[h؂
}				JV_HN_HANSYOKU;


//****** PVDY}X^ ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		KettoNum[10];             //o^ԍ
		_YMD		BirthDate;                //N
		char		SexCD[1];                 //ʃR[h
		char		HinsyuCD[1];              //iR[h
		char		KeiroCD[2];               //ѐFR[h
		char		SankuMochiKubun[1];       //Y敪
		char		ImportYear[4];            //AN
		char		BreederCode[8];           //Y҃R[h
		char		SanchiName[20];           //Yn
		char		HansyokuNum[14][10];       //3㌌ ɐBo^ԍ
		char		crlf[2];                  //R[h؂
}				JV_SK_SANKU;


//****** PWDR[h}X^ ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		RecInfoKubun[1];          //R[hʋ敪
		_RACE_ID	id;                       //<ʏP>
		char		TokuNum[4];               //ʋԍ
		char		Hondai[60];               //{
		char		GradeCD[1];               //O[hR[h
		char		SyubetuCD[2];             //ʃR[h
		char		Kyori[4];                 //
		char		TrackCD[2];               //gbNR[h
		char		RecKubun[1];              //R[h敪
		char		RecTime[4];               //R[h^C
		_TENKO_BABA_INFO		TenkoBaba;        //VEn

		struct _RECUMA_INFO                       //<R[hێn>
                {
				char		KettoNum[10];             //o^ԍ
				char		Bamei[36];                //n
				char		UmaKigoCD[2];             //nLR[h
				char		SexCD[1];                 //ʃR[h
				char		ChokyosiCode[5];          //tR[h
				char		ChokyosiName[34];         //t
				char		Futan[3];                 //Sd
				char		KisyuCode[5];             //RR[h
				char		KisyuName[34];            //R薼
		}			RecUmaInfo[3];
		
		char		crlf[2];                   //R[h؂
}				JV_RC_RECORD;


//****** PXDH ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		TresenKubun[1];           //gZ敪
		_YMD		ChokyoDate;               //N
		char		ChokyoTime[4];            //
		char		KettoNum[10];             //o^ԍ
		char		HaronTime4[4];            //4n^Cv[800M-0M]
		char		LapTime4[3];              //bv^C[800M-600M]
		char		HaronTime3[4];            //3n^Cv[600M-0M]
		char		LapTime3[3];              //bv^C[600M-400M]
		char		HaronTime2[4];            //2n^Cv[400M-0M]
		char		LapTime2[3];              //bv^C[400M-200M]
		char		LapTime1[3];              //bv^C[200M-0M]
		char		crlf[2];                  //R[h؂
}				JV_HC_HANRO;


//****** QODn̏d ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\

		struct _BATAIJYU_INFO                     //<n̏d>
                {
				char		Umaban[2];                //n
				char		Bamei[36];                //n
				char		BaTaijyu[3];              //n̏d
				char		ZogenFugo[1];             //
				char		ZogenSa[3];               //
		}				BataijyuInfo[18];

		char		crlf[2];                   //R[h؂
}				JV_WH_BATAIJYU;


//****** QPDVn ******************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID2	id;                       //<ʏQ>
		_MDHM		HappyoTime;               //\
		char		HenkoID[1];               //ύX
		_TENKO_BABA_INFO		TenkoBaba;        //ݏԏ
		_TENKO_BABA_INFO		TenkoBabaBefore;  //ύXOԏ
		char		crlf[2];                  //R[h؂
}				JV_WE_WEATHER;


//****** QQDoEO ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		char		Umaban[2];                //n
		char		Bamei[36];                //n
		char		JiyuKubun[3];             //R敪
		char		crlf[2];                  //R[h؂
}				JV_AV_INFO;


//************ QRDRύX **************************************** 
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		char		Umaban[2];                //n
		char		Bamei[36];                //n
		_JC_INFO 	JCInfoAfter;              //<ύX>
		_JC_INFO	JCInfoBefore;             //<ύXO>
		char		crlf[2];                  //R[h؂
}				JV_JC_INFO;


//************ QR|PDύX **************************************** 
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		_TC_INFO 	TCInfoAfter;              //<ύX>
		_TC_INFO	TCInfoBefore;             //<ύXO>
		char		crlf[2];                  //R[h؂
}				JV_TC_INFO;


//************ QR|QDR[XύX **************************************** 
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_MDHM		HappyoTime;               //\
		_CC_INFO 	CCInfoAfter;              //<ύX>
		_CC_INFO	CCInfoBefore;             //<ύXO>
		char		JiyuCD[1];                //RR[h
		char		crlf[2];                  //R[h؂
}				JV_CC_INFO;


//****** QSDf[^}CjO\z************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_HM		MakeHM;                   //f[^쐬

		struct _DM_INFO                           //<}CjO\z>
                {
				char		Umaban[2];                //n
				char		DMTime[5];                //\zj^C
				char		DMGosaP[4];               //\z덷[Mx]{
				char		DMGosaM[4];               //\z덷[Mx]|
		}			DMInfo[18];

		char		crlf[2];                   //R[h؂
}				JV_DM_INFO;


//****** QTDJÃXPW[************************************
typedef struct
{
               _RECORD_ID       head;                     //<R[hwb_[>
               _RACE_ID2        id;                       //<ʏQ>
               char             YoubiCD[1];               //jR[h

               struct _JYUSYO_INFO                        //<d܈ē>
               { 
                                char            TokuNum[4];             //ʋԍ
                                char            Hondai[60];              //{
                                char            Ryakusyo10[20];          //10
                                char            Ryakusyo6[12];           //6
                                char            Ryakusyo3[6];            //3
                                char            Nkai[3];                 //d܉[N]
                                char            GradeCD[1];              //O[hR[h
                                char            SyubetuCD[2];            //ʃR[h
                                char            KigoCD[3];               //LR[h
                                char            JyuryoCD[1];             //dʎʃR[h
                                char            Kyori[4];                //
                                char            TrackCD[2];              //gbNR[h
               }                        JyusyoInfo[3];
 
               char             crlf[2];                  //R[h؂
}				JV_YS_SCHEDULE;


//****** QUDnsi ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		KettoNum[10];             //o^ԍ
		char		HansyokuFNum[10];          //nɐBo^ԍ
		char		HansyokuMNum[10];          //nɐBo^ԍ
		char		BirthYear[4];             //N
		char		SaleCode[6];              //ÎҁEsR[h
		char		SaleHostName[40];         //ÎҖ
		char		SaleName[80];             //s̖
		_YMD		FromDate;                 //s̊JÊ(Jn)
		_YMD		ToDate;                   //s̊JÊ(I)
		char		Barei[1];                 //̋n̔N
		char		Price[10];                //i
		char		crlf[2];                  //R[h؂
}				JV_HS_SALE;


//****** QVDn̈ӖR ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		KettoNum[10];             //o^ԍ
		char		Bamei[36];                //n
		char		Origin[64];               //n̈ӖR
		char		crlf[2];                  //R[h؂
}				JV_HY_BAMEIORIGIN;

//****** QWDoʒx ****************************************

//<oʒx n>
typedef struct
{
		char					KettoNum [10];            //o^ԍ
		char					Bamei[36];                //n
		char					RuikeiHonsyoHeiti[9];     //n{܋݌v
		char					RuikeiHonsyoSyogai[9];    //Q{܋݌v
		char					RuikeiFukaHeichi[9];      //nt܋݌v
		char					RuikeiFukaSyogai[9];      //Qt܋݌v
		char					RuikeiSyutokuHeichi[9];   //n܋݌v
		char					RuikeiSyutokuSyogai[9];   //Q܋݌v
		_CHAKUKAISU3_INFO		ChakuSogo;                //
		_CHAKUKAISU3_INFO		ChakuChuo;                //v
		_CHAKUKAISU3_INFO		ChakuKaisuBa[7];          //nʒ
		_CHAKUKAISU3_INFO		ChakuKaisuJyotai[12];     //nԕʒ
		_CHAKUKAISU3_INFO		ChakuKaisuSibaKyori[9];   //ŋʒ
		_CHAKUKAISU3_INFO		ChakuKaisuDirtKyori[9];   //_[gʒ
		_CHAKUKAISU3_INFO		ChakuKaisuJyoSiba[10];    //nʎŒ
		_CHAKUKAISU3_INFO		ChakuKaisuJyoDirt[10];    //nʃ_[g
		_CHAKUKAISU3_INFO		ChakuKaisuJyoSyogai[10];  //nʏQ
		char					Kyakusitu[4][3];          //rX
		char					RaceCount[3];             //o^[X
}				JV_CK_UMA;

//<oʒx {NE݌vя>
typedef struct
{
		char					SetYear[4];               //ݒN
		char					HonSyokinHeichi[10];      //n{܋v
		char					HonSyokinSyogai[10];      //Q{܋v
		char					FukaSyokinHeichi[10];     //nt܋v
		char					FukaSyokinSyogai[10];     //Qt܋v
		_CHAKUKAISU5_INFO		ChakuKaisuSiba;           //Œ
		_CHAKUKAISU5_INFO		ChakuKaisuDirt;           //_[g
		_CHAKUKAISU4_INFO		ChakuKaisuSyogai;         //Q
		_CHAKUKAISU4_INFO		ChakuKaisuSibaKyori[9];   //ŋʒ
		_CHAKUKAISU4_INFO		ChakuKaisuDirtKyori[9];   //_[gʒ
		_CHAKUKAISU4_INFO		ChakuKaisuJyoSiba[10];    //nʎŒ
		_CHAKUKAISU4_INFO		ChakuKaisuJyoDirt[10];    //nʃ_[g
		_CHAKUKAISU3_INFO		ChakuKaisuJyoSyogai[10];  //nʏQ
}				_CK_HON_RUIKEISEI_INFO;

//<oʒx R>
typedef struct
{
		char					KisyuCode[5];             //RR[h
		char					KisyuName[34];            //R薼
		_CK_HON_RUIKEISEI_INFO	HonRuikei[2];             //<{NE݌vя>
}				JV_CK_KISYU;

//<oʒx t>
typedef struct
{
		char					ChokyosiCode[5];          //tR[h
		char					ChokyosiName[34];         //t
		_CK_HON_RUIKEISEI_INFO	HonRuikei[2];             //<{NE݌vя>
}				JV_CK_CHOKYOSI;

//<oʒx n>
typedef struct
{
		char					BanusiCode[6];            //nR[h
		char					BanusiName_Co[64];        //n喼i@liLj
		char					BanusiName[64];           //n喼i@lij
		_SEI_RUIKEI_INFO		HonRuikei[2];             //<{NE݌vя>
}				JV_CK_BANUSI;

//<oʒx Yҏ>
typedef struct
{
		char					BreederCode[8];           //Y҃R[h
		char					BreederName_Co[72];       //YҖi@liLj
		char					BreederName[72];          //YҖi@lij
		_SEI_RUIKEI_INFO		HonRuikei[2];             //<{NE݌vя>
}				JV_CK_BREEDER;

typedef struct
{
		_RECORD_ID				head;                     //<R[hwb_[>
		_RACE_ID				id;                       //<ʏP>
		JV_CK_UMA				UmaChaku;                 //<oʒx n>
		JV_CK_KISYU				KisyuChaku;               //<oʒx R>
		JV_CK_CHOKYOSI			ChokyoChaku;              //<oʒx t>
		JV_CK_BANUSI			BanusiChaku;              //<oʒx n>
		JV_CK_BREEDER			BreederChaku;             //<oʒx Yҏ>
		char					crlf[2];                  //R[h؂
}				JV_CK_CHAKU;

//****** QXDn ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		HansyokuNum[10];           //ɐBo^ԍ
		char		KeitoId[30];              //nID
		char		KeitoName[36];            //n
		char		KeitoEx[6800];            //n
		char		crlf[2];                  //R[h؂
}				JV_BT_KEITO;

//****** RODR[X ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		JyoCD[2];                 //nR[h
		char		Kyori[4];                 //
		char		TrackCD[2];               //gbNR[h
		_YMD		KaishuDate;               //R[XCN
		char		CourseEx[6800];           //R[X
		char		crlf[2];                  //R[h؂
}				JV_CS_COURSE;

//****** RPDΐ^f[^}CjO\z ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		_HM		MakeHM;                       //f[^쐬

		struct _TM_INFO                       //<}CjO\z>
                {
				char		Umaban[2];        //n
				char		TMScore[4];       //\XRA
		}			TMInfo[18];

		char		crlf[2];                  //R[h؂
}				JV_TM_INFO;

//****** RQDd(WIN5) ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_YMD		KaisaiDate;               //JÔN
		char		reserved1[2];             //\

		struct _WF_RACE_INFO
                {
                char JyoCD[2];                //nR[h
                char Kaiji[2];                //JÉ[N]
                char Nichiji[2];              //JÓ[N]
                char RaceNum[2];              //[Xԍ
		}			WFRaceInfo[5];

		char 		reserved2[6];             //\
		char		Hatsubai_Hyo[11];         //d[

		struct _WF_YUKO_HYO_INFO
                {
                char Yuko_Hyo[11];            //L[
		}			WFYukoHyoInfo[5];

		char		HenkanFlag[1];            //Ԋ҃tO
		char		FuseiritsuFlag[1];        //stO
		char		TekichunashiFlag[1];      //ItO
		char		COShoki[15];              //L[I[o[z
		char		COZanDaka[15];            //L[I[o[zc

		struct _WF_PAY_INFO
                {
                char Kumiban[10];             //g
                char Pay[9];                  //dߋ
                char Tekichu_Hyo[10];         //I[
		}			WFPayInfo[243];

		char		crlf[2];                  //R[h؂
}				JV_WF_INFO;

//****** RRDnO ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		_RACE_ID	id;                       //<ʏP>
		char		KettoNum[10];             //o^ԍ
		char		Bamei[36];                //n
		char		ShutsubaTohyoJun[3];      //on[t
		char		ShussoKubun[1];           //o敪
		char		JogaiJotaiKubun[1];       //Oԋ敪
		char		crlf[2];                  //R[h؂
}				JV_JG_JOGAIBA;

//****** RSDEbh`bv ****************************************
typedef struct
{
		_RECORD_ID	head;                     //<R[hwb_[>
		char		TresenKubun[1];           //gZ敪
		_YMD		ChokyoDate;               //N
		char		ChokyoTime[4];            //
		char		KettoNum[10];             //o^ԍ
		char		Course[1];                // R[X
		char		BabaAround[1];            // n
		char		reserved[1];              // \
		char		HaronTime10[4];           //10n^Cv[2000M-0M]
		char		LapTime10[3];             //bv^C[2000M-1800M]
		char		HaronTime9[4];            //9n^Cv[1800M-0M]
		char		LapTime9[3];              //bv^C[1800M-1600M]
		char		HaronTime8[4];            //8n^Cv[1600M-0M]
		char		LapTime8[3];              //bv^C[1600M-1400M]
		char		HaronTime7[4];            //7n^Cv[1400M-0M]
		char		LapTime7[3];              //bv^C[1400M-1200M]
		char		HaronTime6[4];            //6n^Cv[1200M-0M]
		char		LapTime6[3];              //bv^C[1200M-1000M]
		char		HaronTime5[4];            //5n^Cv[1000M-0M]
		char		LapTime5[3];              //bv^C[1000M-800M]
		char		HaronTime4[4];            //4n^Cv[800M-0M]
		char		LapTime4[3];              //bv^C[800M-600M]
		char		HaronTime3[4];            //3n^Cv[600M-0M]
		char		LapTime3[3];              //bv^C[600M-400M]
		char		HaronTime2[4];            //2n^Cv[400M-0M]
		char		LapTime2[3];              //bv^C[400M-200M]
		char		LapTime1[3];              //bv^C[200M-0M]
		char		crlf[2];                  //R[h؂
}				JV_WC_WOOD;


#endif	// __JV_DATA_STRUCT

